#www.lasseclausen.com/lab/
#Use at your own risk
#Last-Modified: 04/01/2016
"""
Name-US:Add Null to Selection v2.0
Description-US:Different Modifier-Keys explained in Script..!
 
//DEFAULT//
Adds Null at Axis
(No Object selected): Adds Null into Scene
 
//SHIFT-Click//
(One Object selected): Axis-Null as Child
(Multiple Objects selected): Null as Child for every selected Object
 
//ALT-Click//
(One Object selected): Groups Selection under selected Axis
(Multiple Objects selected): Groups Selection under last selected Object
 
//ALT-SHIFT-Click//
Groups Objects at PSR 0;1;0
 
//CTRL-Click//
Adds Axis-Null as Next Object

//CTRl+Alt-Click//
Null for every selected Object as Next Object

//CTRL+SHIFT-Click//
(One Object selected): Axis-AEC-Null as Child
(Multiple Objects selected): AEC_Null as Child for every selected Object

//CTRL+ALT+SHIFT-Click//
Adds Axis-AEC-Light as Child

 
"""
import c4d
from c4d import gui
 
bd=doc.GetActiveBaseDraw()
sel=doc.GetActiveObjects(c4d.GETACTIVEOBJECTFLAGS_SELECTIONORDER)
sel_childs=doc.GetActiveObjects(c4d.GETACTIVEOBJECTFLAGS_CHILDREN)
persp=doc.GetBaseDraw(0)
bc=c4d.BaseContainer()
null=c4d.BaseObject(c4d.Onull)
 
def AEC_Null():
    null=c4d.BaseObject(c4d.Onull)
    null[c4d.ID_BASEOBJECT_USECOLOR]=1
    null[c4d.ID_BASEOBJECT_COLOR]=c4d.Vector(0.75, 1, 0.75)
    null[c4d.NULLOBJECT_ICONCOL]=True
    null[c4d.NULLOBJECT_DISPLAY]=10
    null[c4d.NULLOBJECT_RADIUS]=25.0
    null[c4d.NULLOBJECT_ORIENTATION]=1
    return null

def AECLight():
    light=c4d.BaseObject(c4d.Olight)
    light[c4d.LIGHT_NOLIGHTRADIATION]=0
    light[c4d.LIGHT_DETAILS_AMBIENT]=0
    light[c4d.LIGHT_DETAILS_DIFFUSE]=0
    light[c4d.LIGHT_DETAILS_SPECULAR]=0
    light[c4d.LIGHT_DETAILS_GI]=0
    light[c4d.LIGHT_SHOWILLUMINATION]=0
    light[c4d.LIGHT_SHOWCLIPPING]=0
    light[c4d.LIGHT_DETAILS_SEPARATEPASS]=0
    light[c4d.LIGHT_AFX]=1
    light[c4d.LIGHT_ICONCOL]=1
    light[c4d.LIGHT_COLOR]=c4d.Vector(0.75, 1, 0.75)
    return light
 
 
def main():
 
### NOTHING SELECTED ###
 
    #Adds Null into Scene
    if not sel:
        doc.StartUndo()
        null=c4d.BaseObject(c4d.Onull)
        doc.AddUndo(c4d.UNDOTYPE_NEW, null)
        doc.InsertObject(null, checknames=True)
        doc.EndUndo()
        c4d.EventAdd()
        return
     
### DEFAULT ###
     
    #Adds Null at Axis
    c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD, c4d.BFM_INPUT_CHANNEL, bc)        
    if bc[c4d.BFM_INPUT_QUALIFIER]==0:
        doc.StartUndo() 
        null=c4d.BaseObject(c4d.Onull)
        doc.AddUndo(c4d.UNDOTYPE_NEW, null)
        c4d.CallCommand(431000012)        # Axis Workplane
        worldmg=c4d.modules.snap.GetWorkplaneMatrix(doc, bd=persp)
        doc.InsertObject(null, checknames=True)
        null.SetMg(worldmg)
        doc.AddUndo(c4d.UNDOTYPE_CHANGE, null)
        doc.SetSelection(null, c4d.SELECTION_SUB)
        c4d.CallCommand(1027594, 1027594)  # Planar Workplane
        c4d.CallCommand(431000007)         # Align Workplane to Y        
        doc.EndUndo()
        c4d.EventAdd()
        return
 
### SHIFT-Click ###
 
    #Axis-Null as Child
    if len(sel)==1:
        c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD, c4d.BFM_INPUT_CHANNEL, bc)
        if bc[c4d.BFM_INPUT_QUALIFIER]==1:
            doc.StartUndo()
            null=c4d.BaseObject(c4d.Onull)
            doc.AddUndo(c4d.UNDOTYPE_NEW, null)
            c4d.CallCommand(431000012)        # Axis Workplane
            worldmg=c4d.modules.snap.GetWorkplaneMatrix(doc, bd=persp)
            doc.InsertObject(null, checknames=True, parent=sel[0])
            layer=sel[0].GetLayerObject(doc)
            if layer:
                null.SetLayerObject(layer)
            name=sel[0].GetName()
            null.SetName(name)
            null.SetMg(worldmg)
            doc.AddUndo(c4d.UNDOTYPE_CHANGE, null)
            doc.SetSelection(null, c4d.SELECTION_SUB)
            c4d.CallCommand(1027594, 1027594)  # Planar Workplane
            c4d.CallCommand(431000007)         # Align Workplane to Y        
            doc.EndUndo()
            c4d.EventAdd()
            return
 
    #Childnull for every selected Object
    c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD, c4d.BFM_INPUT_CHANNEL, bc)   
    if bc[c4d.BFM_INPUT_QUALIFIER]==1:
        doc.StartUndo()
        for x in sel_childs:
            null=c4d.BaseObject(c4d.Onull)
            doc.AddUndo(c4d.UNDOTYPE_NEW, null)
            layer=x.GetLayerObject(doc)
            if layer:
                null.SetLayerObject(layer)
            name=x.GetName()
            null.InsertUnder(x)
            null.SetName(name)
            c4d.EventAdd()
        doc.EndUndo()
        return
 
### CTRL-Click ###

    #Adds Axis-Null as Next Object
    c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD, c4d.BFM_INPUT_CHANNEL, bc)
    if bc[c4d.BFM_INPUT_QUALIFIER]==2:
        doc.StartUndo()
        null=c4d.BaseObject(c4d.Onull)
        name=sel[0].GetName()
        layer=sel[0].GetLayerObject(doc)
        if layer:
            null.SetLayerObject(layer)
        doc.AddUndo(c4d.UNDOTYPE_NEW, null)
        c4d.CallCommand(431000012)        # Axis Workplane
        worldmg=c4d.modules.snap.GetWorkplaneMatrix(doc, bd=persp)
        null.SetName(name)
        null.InsertBefore(sel[0])
        null.SetMg(worldmg)
        doc.AddUndo(c4d.UNDOTYPE_CHANGE, null)
        doc.SetSelection(null, c4d.SELECTION_SUB)
        c4d.CallCommand(1027594, 1027594)  # Planar Workplane
        c4d.CallCommand(431000007)         # Align Workplane to Y        
        doc.EndUndo()
        c4d.EventAdd()
        return

### CTRl+Alt-Click ###
    #Null for every selected Object as Next Object
    c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD, c4d.BFM_INPUT_CHANNEL, bc)
    if bc[c4d.BFM_INPUT_QUALIFIER]==6: #CTRL+ALT-Click
        doc.StartUndo()
        for x in sel_childs:
            Parent=x.GetUp()
            xmg=x.GetMg()
            null=c4d.BaseObject(c4d.Onull)
            doc.AddUndo(c4d.UNDOTYPE_NEW, null)
            layer=x.GetLayerObject(doc)
            if layer:
                null.SetLayerObject(layer)
            name=x.GetName()
            null.InsertBefore(x)
            null.SetMg(xmg)
            null.SetName(name)
            c4d.EventAdd()
        doc.EndUndo()
        return

### ALT-Click ###    
     
    #Groups Selection under selected Axis
    c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD, c4d.BFM_INPUT_CHANNEL, bc)
    if bc[c4d.BFM_INPUT_QUALIFIER]==4: #ALT-Click:
        if not c4d.IsCommandChecked(12298) and not c4d.IsCommandChecked(12101): #If not Model or Objectmode
            doc.StartUndo()
            null=c4d.BaseObject(c4d.Onull)
            LastObject=sel[len(sel)-1]
            name="rt_"+LastObject.GetName()
            layer=LastObject.GetLayerObject(doc)
            if layer:
                null.SetLayerObject(layer)
            c4d.CallCommand(431000012)        # Axis Workplane
            worldmg=c4d.modules.snap.GetWorkplaneMatrix(doc, bd=persp)
            doc.AddUndo(c4d.UNDOTYPE_NEW, null)
            doc.InsertObject(null, checknames=True)
            null.InsertBefore(sel[0])
            null.SetMg(worldmg)
            null.SetName(name)
            doc.SetSelection(null, c4d.SELECTION_NEW)
            c4d.CallCommand(1027594, 1027594)  # Planar Workplane
            c4d.CallCommand(431000007)         # Align Workplane to Y
            for x in sel:
                mg=x.GetMg()
                doc.AddUndo(c4d.UNDOTYPE_CHANGE, x)
                x.InsertUnder(null)
                x.SetMg(mg)
            c4d.CallCommand(12101) # Object Mode
            doc.EndUndo()
            c4d.EventAdd()     
            return      
         
        #Groups Selection under last selected Object
        doc.StartUndo()
        null=c4d.BaseObject(c4d.Onull)
        LastObject=sel[len(sel)-1]
        if not LastObject: return
        name=LastObject.GetName()
        layer=LastObject.GetLayerObject(doc)
        if layer:
            null.SetLayerObject(layer)
        lastmg=LastObject.GetMg()
        doc.StartUndo()
        doc.AddUndo(c4d.UNDOTYPE_NEW, null)
        doc.InsertObject(null)
        null.InsertBefore(LastObject)
        null.SetMg(lastmg)
        null.SetName(name)
        doc.SetSelection(null, c4d.SELECTION_NEW)
        for x in sel:
            doc.AddUndo(c4d.UNDOTYPE_CHANGE, x)
            mg=x.GetMg()
            x.InsertUnder(null)
            x.SetMg(mg)
        doc.EndUndo()
        c4d.EventAdd()
        return
 
### ALT-SHIFT-Click ###
 
    #Groups Objects at PSR 0;1;0
    c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD, c4d.BFM_INPUT_CHANNEL, bc) 
    if bc[c4d.BFM_INPUT_QUALIFIER]==5:
        LastObject=sel[len(sel)-1]
        if not LastObject: return
        null=c4d.BaseObject(c4d.Onull)
        doc.StartUndo()
        doc.AddUndo(c4d.UNDOTYPE_NEW, null)
        doc.InsertObject(null)
        null.InsertBefore(LastObject)
        for x in sel:
            layer=x.GetLayerObject(doc)
            name=x.GetName()
            doc.AddUndo(c4d.UNDOTYPE_CHANGE, x)
            x.InsertUnder(null)   
        if layer:
            null.SetLayerObject(layer)
        null.SetName(name)
        doc.SetSelection(null, c4d.SELECTION_NEW)
        doc.EndUndo()
        c4d.EventAdd()
        return
 
### CTRL+SHIFT-Click ###
 
    #AEC_Null for one selected Object / Axis
    if len(sel)==1:
        c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD, c4d.BFM_INPUT_CHANNEL, bc)
        if bc[c4d.BFM_INPUT_QUALIFIER]==3: #CTRL+SHIFT-Click
            doc.StartUndo()
            aec_null=AEC_Null()
            tag=c4d.BaseTag(465000402)
            name="[AEC] "+sel[0].GetName()
            layer=sel[0].GetLayerObject(doc)
            doc.AddUndo(c4d.UNDOTYPE_NEW, aec_null)
            c4d.CallCommand(431000012)        # Axis Workplane
            worldmg=c4d.modules.snap.GetWorkplaneMatrix(doc, bd=persp)
            doc.InsertObject(aec_null, checknames=True)
            aec_null.InsertUnder(sel[0])
            aec_null.SetMg(worldmg)
            aec_null.InsertTag(tag)
            if layer:
                aec_null.SetLayerObject(layer)
            aec_null.SetName(name)
            tag[c4d.ID_BASELIST_NAME]=sel[0].GetName()
            doc.AddUndo(c4d.UNDOTYPE_CHANGE, aec_null)
            doc.SetSelection(aec_null, c4d.SELECTION_SUB)
            c4d.CallCommand(1027594, 1027594)  # Planar Workplane
            c4d.CallCommand(431000007)         # Align Workplane to Y
            doc.EndUndo()
            c4d.EventAdd()
            return
     
    #AEC_Null for every selected Object
    c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD, c4d.BFM_INPUT_CHANNEL, bc)
    if bc[c4d.BFM_INPUT_QUALIFIER]==3: #CTRL+SHIFT-Click
        doc.StartUndo()
        for x in sel_childs:
            aec_null=AEC_Null()
            doc.AddUndo(c4d.UNDOTYPE_NEW, aec_null)
            tag=c4d.BaseTag(465000402)
            name="[AEC] "+x.GetName()
            layer=x.GetLayerObject(doc)
            aec_null.InsertUnder(x)
            aec_null.InsertTag(tag)
            if layer:
                aec_null.SetLayerObject(layer)
            aec_null.SetName(name)
            tag[c4d.ID_BASELIST_NAME]=x.GetName()
            doc.SetSelection(aec_null, c4d.SELECTION_SUB)
            c4d.EventAdd()
        doc.EndUndo()
        return

### CTRL+ALT+SHIFT-Click ###
 
    #AEC_Light for one selected Object / Axis
    if len(sel)==1:
        c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD, c4d.BFM_INPUT_CHANNEL, bc)
        if bc[c4d.BFM_INPUT_QUALIFIER]==7: #CTRL+ALT+SHIFT-Click
            doc.StartUndo()
            light=AECLight()
            name="[Light] "+sel[0].GetName()
            layer=sel[0].GetLayerObject(doc)
            c4d.CallCommand(431000012)        # Axis Workplane
            worldmg=c4d.modules.snap.GetWorkplaneMatrix(doc, bd=persp)
            doc.AddUndo(c4d.UNDOTYPE_NEW, light)
            doc.InsertObject(light, checknames=True)
            light.InsertUnder(sel[0])
            light.SetMg(worldmg)
            if layer:
                light.SetLayerObject(layer)
            light.SetName(name)
            doc.SetSelection(light, c4d.SELECTION_SUB)
            c4d.CallCommand(1027594, 1027594)  # Planar Workplane
            c4d.CallCommand(431000007)         # Align Workplane to Y
            doc.EndUndo()
            c4d.EventAdd()
            return
        
    #AEC_Light for every selected Object
    c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD, c4d.BFM_INPUT_CHANNEL, bc)
    if bc[c4d.BFM_INPUT_QUALIFIER]==7: #CTRL+ALT+SHIFT-Click
        doc.StartUndo()
        for x in sel_childs:
            light=AECLight()
            doc.AddUndo(c4d.UNDOTYPE_NEW, light)
            name="[Light] "+x.GetName()
            layer=x.GetLayerObject(doc)
            light.InsertUnder(x)
            if layer:
                light.SetLayerObject(layer)
            light.SetName(name)
            doc.SetSelection(light, c4d.SELECTION_SUB)
            c4d.EventAdd()
        doc.EndUndo()
        return

if __name__=='__main__':
    main()